// SmartSock.h: CSmartSock NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#pragma once

#include "W2L.h"
#include <sys/socket.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <errno.h>

#define BOOL bool
#define LPTSTR char*
#define LPCTSTR const char*
#define LPCSTR const char*
#define BYTE  unsigned char
#define WORD  unsigned short
#define DWORD unsigned long
#define SOCKET int

// WinSock2^CAEgΉbp[NX	http://2sen.dip.jp/friio/
class CSmartSock
{
public:
	enum					// LastErrorR[h
	{
		EC_NOERROR,			// I
		EC_SOCKERROR,		// \PbgG[
		EC_TIMEOUT,			// ^CAEg
		EC_SOCKINVALID,		// \Pbg
		EC_PARAMINVALID		// p[^
	};

	CSmartSock();
	virtual ~CSmartSock();

// TCP\Pbg
	const BOOL Connect(LPCTSTR lpszHost, const WORD wPort, const DWORD dwTimeOut = 0UL);
	const BOOL Connect(const DWORD dwIP, const WORD wPort, const DWORD dwTimeOut = 0UL);

	const BOOL Listen(const WORD wPort);
	CSmartSock * Accept(void);

	const BOOL Send(const BYTE *pBuff, const DWORD dwLen, const DWORD dwTimeOut = 0UL);
	const BOOL Recv(BYTE *pBuff, const DWORD dwLen, const DWORD dwTimeOut = 0UL);
	const DWORD SendOnce(const BYTE *pBuff, const DWORD dwMaxLen, const DWORD dwTimeOut = 0UL);
	const DWORD RecvOnce(BYTE *pBuff, const DWORD dwMaxLen, const DWORD dwTimeOut = 0UL);

	const BOOL GetLocalAddr(DWORD *pdwIP, WORD *pwPort = NULL);
	const BOOL GetPeerAddr(DWORD *pdwIP, WORD *pwPort = NULL);

// UDP\Pbg
	const BOOL Bind(void);

	const DWORD SendTo(const DWORD dwIP, const WORD wPort, const BYTE *pBuff, const DWORD dwLen);
	const DWORD SendTo(LPCTSTR lpszHost, const WORD wPort, const BYTE *pBuff, const DWORD dwLen);
	const DWORD RecvFrom(BYTE *pBuff, const DWORD dwLen, DWORD *pdwIP = NULL, WORD *pwPort = NULL);

	const BOOL Close(void);

	static const DWORD HostToIP(LPCTSTR lpszHost);
	static const DWORD IPToHost(LPTSTR lpszHost, const DWORD dwIP);

	const DWORD GetLastError(void) const;

protected:
	static const BOOL InitWinSock2(void);
	static const BOOL FreeWinSock2(void);

	enum {SOCKTYPE_NON, SOCKTYPE_TCP, SOCKTYPE_UDP};

	int m_Socket;				// \Pbgnh
	BYTE m_bSockType;				// \Pbg^Cv
	DWORD m_dwLastError;			// ŏIG[R[h
	static DWORD dwInstanceNum;		// CX^X̐
};
